#ifndef _SQLEXPORT_CPP
#define _SQLEXPORT_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WindowsX.H>
#include <ShellAPI.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <SQL.H>
#include <SQLExt.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"
#include "../../SharedClasses/CRC32/CRC.H"
#include "../../SharedClasses/SQLClass/SQLClass.H"
#include "../../SharedClasses/SQLClass/SQLRoutines.H"

#include "../SockServer/SockServer.H"

#include "NSWFL.H"
#include "Init.H"
#include "Entry.H"
#include "Routines.H"
#include "Command.H"
#include "SQLExport.H"

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

const char *NULLSTR = "NULL";
const int NULLSTRLEN = 4;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void WriteNull(FILE *TargetHandle)
{
    fwrite(&NULLSTRLEN, sizeof(NULLSTRLEN), 1, TargetHandle);
    fwrite(NULLSTR, sizeof(char), NULLSTRLEN, TargetHandle);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void ReplaceSingleQuotes(SQLCHAR *Data, SQLINTEGER Length)
{
    int RPos = 0;

    while(RPos < Length)
    {
        if(Data[RPos] == '\'')
            Data[RPos] = '`';

        RPos++;
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

SQLINTEGER CharTrim(SQLCHAR *Data, SQLINTEGER Length)
{
    SQLINTEGER Pos = Length;

    if(Length == 0)
        return Length;

    if(Data[Length-1] != ' ')
        return Length;

    Pos--;

    while(Pos != 0 && Data[Pos] == ' ')
        Pos--;

    if(Data[Pos] != ' ')
        Pos++;

    Data[Pos] = '\0';

    return Pos;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int ExportSQLResults(SocketServer *pSockSrvr, int iClient, char *Statement, char *OutFileName)
{
    HSTMT StatementHandle;
    HSTMT UpdateStatementHandle;

    FILE *TargetHandle = NULL;

    char xStatement[255];
    char StatusText[1024];

    if(!CCI.CustDB.DBExecute(Statement, &StatementHandle))
    {
        sprintf(StatusText, "ExportSQLResults SELECT DBexecute: Fail on (%s)", Statement);
		WriteLog(pSockSrvr->icClientID[iClient], StatusText);
        return SQL_IMPORT_RESULT_ERROR;
    }

    sprintf(xStatement, "UPDATE %s SET Portal_Dirty = 3 WHERE Portal_Dirty = 2", CCI.sImportTable);
    if(!CCI.CustDB.DBExecute(xStatement, &UpdateStatementHandle))
    {
        sprintf(StatusText, "UPDATE DBexecute: Fail on (%s)", xStatement);
		WriteLog(pSockSrvr->icClientID[iClient], StatusText);

        DBCloseCursor(StatementHandle);
        return SQL_IMPORT_RESULT_ERROR;
    }
    DBCloseCursor(UpdateStatementHandle);

    SQLSMALLINT outColumnCount = 0;
    if(SQLNumResultCols(StatementHandle, &outColumnCount) != SQL_SUCCESS)
    {
		WriteLog(pSockSrvr->icClientID[iClient], "SQLNumResultCols: Error.");

        DBCloseCursor(StatementHandle);
        return SQL_IMPORT_RESULT_ERROR;
    }

    SQLINTEGER outRowCount = 0;
    if(SQLRowCount(StatementHandle, &outRowCount) != SQL_SUCCESS)
    {
		WriteLog(pSockSrvr->icClientID[iClient], "SQLRowCount: Error.");

		DBCloseCursor(StatementHandle);
        return SQL_IMPORT_RESULT_ERROR;
    }

    if(outRowCount == 0)
    {
        sprintf(StatusText, "Query returned zero rows.");
		WriteLog(pSockSrvr->icClientID[iClient], StatusText);

        DBCloseCursor(StatementHandle);
        return SQL_IMPORT_RESULT_ZEROROWS;
    }
    else{
        sprintf(StatusText, "Query returned %d rows with %d columbs.", outRowCount, outColumnCount);
		WriteLog(pSockSrvr->icClientID[iClient], StatusText);
    }

    if((TargetHandle = fopen(OutFileName, "wb")) == NULL)
    {
        sprintf(StatusText, "TargetFile: Binary write error with (%s).", OutFileName);
		WriteLog(pSockSrvr->icClientID[iClient], StatusText);

        DBCloseCursor(StatementHandle);
        return SQL_IMPORT_RESULT_ERROR;
    }

    int ImportTableNameLen = strlen(CCI.sImportTable);
    fwrite(&ImportTableNameLen, sizeof(ImportTableNameLen), 1, TargetHandle); // Write import table name len
    fwrite(CCI.sImportTable, sizeof(char), ImportTableNameLen, TargetHandle); // Write import table name
    fwrite(&outColumnCount, sizeof(outColumnCount), 1, TargetHandle); // Write number of columbs
    fwrite(&outRowCount, sizeof(outRowCount), 1, TargetHandle);       // Write number of rows

    //---------------( Get Columb Information )---
    SQLSMALLINT inColumnNameLen = 256;

	SQLUINTEGER outColumnSizePtr = 0;

    SQLSMALLINT outColumnNameLen = 0;
    SQLSMALLINT *outDataType = 0;
    SQLSMALLINT outDecimalDigitsPtr = 0;
    SQLSMALLINT outNullablePtr = 0;

    SQLCHAR outColumnName[256];

    SQLRETURN SQLResult = 0;

    int ColumbLoop = 0;

    outDataType = (SQLSMALLINT *) calloc( sizeof(SQLSMALLINT), outColumnCount);

    do{
        SQLResult = SQLDescribeCol(StatementHandle, ColumbLoop + 1, outColumnName, inColumnNameLen,
            &outColumnNameLen, &outDataType[ColumbLoop], &outColumnSizePtr, &outDecimalDigitsPtr, &outNullablePtr
        );

        if(SQLResult == SQL_SUCCESS)
        {
            fwrite(&outColumnNameLen, sizeof(outColumnNameLen), 1, TargetHandle);
            fwrite(outColumnName, sizeof(char), outColumnNameLen, TargetHandle);
        }
        ColumbLoop++;
    }
    while(SQLResult == SQL_SUCCESS);

    //---------------( Get Columb Data )---
    while(DBFetch(StatementHandle))
    {
        SQLINTEGER DataLength = 0;

        ColumbLoop = 0;
        while(ColumbLoop < outColumnCount)
        {
            SQLSMALLINT DataType = outDataType[ColumbLoop];

            if(DataType == SQL_CHAR || DataType == SQL_VARCHAR || DataType == SQL_LONGVARCHAR)
            {
                SQLCHAR SQLBuffer1[1024 + 1];
				memset(SQLBuffer1, 0, sizeof(SQLBuffer1));

                if(DBGetData(StatementHandle, ColumbLoop+1, SQL_C_CHAR, SQLBuffer1, 1024, &DataLength))
                {
                    if(DataLength == -1)
                    {
                        WriteNull(TargetHandle);
                    }
                    else{
						SQLBuffer1[DataLength] = '\0';
                        DataLength = CharTrim(SQLBuffer1, DataLength);
                        ReplaceSingleQuotes(SQLBuffer1, DataLength);

                        DataLength = (DataLength + 2); // To make room for the single quotes
                        fwrite(&DataLength, sizeof(DataLength), 1, TargetHandle);
                        DataLength = (DataLength - 2); // Because we only write the origional trimmed length

                        fwrite("'", 1, 1, TargetHandle); // Wrap the data in single quotes
                        fwrite(SQLBuffer1, sizeof(char), DataLength, TargetHandle);
                        fwrite("'", 1, 1, TargetHandle); // Wrap the data in single quotes
					}
				}
            }
            else if(DataType == SQL_TYPE_DATE || DataType == SQL_TYPE_TIME || DataType == SQL_TYPE_TIMESTAMP)
            {
				SQLCHAR SQLBuffer2[255];

                if(DBGetData(StatementHandle, ColumbLoop+1, SQL_C_CHAR, SQLBuffer2, 255, &DataLength))
                {
                    if(DataLength == -1)
                    {
                        WriteNull(TargetHandle);
                    }
                    else{
	                    SQLBuffer2[DataLength] = '\0';
                        DataLength = CharTrim(SQLBuffer2, DataLength);
                        ReplaceSingleQuotes(SQLBuffer2, DataLength);

                        DataLength = (DataLength + 2); // To make room for the single quotes
                        fwrite(&DataLength, sizeof(DataLength), 1, TargetHandle);
                        DataLength = (DataLength - 2); // Because we only write the origional trimmed length

                        fwrite("'", 1, 1, TargetHandle); // Wrap the data in single quotes
                        fwrite(SQLBuffer2, sizeof(char), DataLength, TargetHandle);
                        fwrite("'", 1, 1, TargetHandle); // Wrap the data in single quotes
                    }

                }
			}
            else if(DataType == SQL_INTEGER || SQL_DECIMAL || SQL_NUMERIC || SQL_SMALLINT || SQL_REAL)
            {
                SQLINTEGER SQLBuffer3 = 0;
                char CharData[32];

                if(DBGetData(StatementHandle, ColumbLoop+1, SQL_C_LONG, &SQLBuffer3, 32, &DataLength))
                {
                    if(DataLength == -1)
                    {
                        WriteNull(TargetHandle);
                    }
                    else{
                        sprintf(CharData, "%d", SQLBuffer3);
                        DataLength = strlen(CharData);
                        fwrite(&DataLength, sizeof(DataLength), 1, TargetHandle);
                        fwrite(CharData, sizeof(char), DataLength, TargetHandle);
                    }
                }
            }
            else if(DataType == SQL_DOUBLE || DataType == SQL_FLOAT)
            {
                SQLDOUBLE SQLBuffer4 = 0;
                char CharData[32];

                if(DBGetData(StatementHandle, ColumbLoop+1, SQL_C_DOUBLE, &SQLBuffer4, 32, &DataLength))
                {
                    if(DataLength == -1)
                    {
                        WriteNull(TargetHandle);
                    }
                    else{
                        sprintf(CharData, "%f", SQLBuffer4);
                        DataLength = strlen(CharData);
                        fwrite(&DataLength, sizeof(DataLength), 1, TargetHandle);
                        fwrite(CharData, sizeof(char), DataLength, TargetHandle);
                    }
                }
            }
            else{
                sprintf(StatusText, "Unknown SQL data type. Table: %s, Select Columb: %d, Type: %d", CCI.sImportTable, ColumbLoop, DataType);
				WriteLog(pSockSrvr->icClientID[iClient], StatusText);
            }

            ColumbLoop++;
        }
    }

    DBCloseCursor(StatementHandle);

    if(TargetHandle) fclose(TargetHandle);

    return SQL_IMPORT_RESULT_OK;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
